Comment *

Assembled under Turbo Assembler 1.0

STSPLAY.ASM
  This is a modified version Alan D. Jones' program PLAY.ASM.  The
  original program would load a sound file specified on the command line
  into memory and play it through the built-in speaker.  The sound file
  is a bit stream which represents the DERIVATIVE (think calculus) of the
  sound wave.

Modifications by

  Daniel B. Singer / Stripd Tiger Software
  June 1989

Summary of Modifications:

  Command line and disk activity has been removed from this program.
  The program has been turned into a procedure intended to be linked into
     a Turbo Pascal (4.0 and beyond) unit.

Tested and Debugged under MS-DOS 3.2, TASM 1.0, and TP 5.5 on a Compaq
  Portable II (286).

The original program was compatible with 8088, 8086 and all subsequently
  faster processors.  I have striven to maintain that compatibility.

Daniel B. Singer
Stripd Tiger Software
2245 Iroquois Road
Wilmette, IL 60091-1409

*

.model tpascal      ; tell TASM to do entry and exit code for us

;--- Constants --------------

COUNTR	EQU	72 ;16572 HZ

TCADRC	EQU	43H            ; Jones didn't document this program much
TCADRD	EQU	40H            ; I will try to explain what is going on
                               ; as best as I can.  These constants are
TCMODE	EQU	34H            ; not at all descriptive... but I have no
TC2MODE	EQU	0B8H           ; idea what they mean, either.  I am not
                               ; an expert on playing Almighty with the
PPIADR	EQU	61H            ; system resources.
NORMPPI	EQU	48H

;-------------------------------------------
; 128 words of stack space was reserved by the command-line version of this
; program.  I have removed the allocation because it is now a module which
; will be linked to a TP program which has its own stack.
;-------------------------------------------
;
; Pascal declaration should look like this:
;
; procedure soundPlay (DataPtr : <pointerType>; dataLength : word); EXTERNAL;
;           {$L play.obj     link in object module}


.code
	ASSUME	CS:CODE,DS:CODE   ; DS assumption makes CS:variables
                                  ; easier to manage
        public play
start:
play    proc near

; *** add startAddr:word to this list (at the end) and put ", startAddr"
; in the pascal definition above (and in BITSOUND.PAS, too, of course)

          arg soundSeg:word,soundOfs:word,soundLen:word
          push ds
;set DS and ES

	PUSH	CS
	POP	DS
	PUSH	CS
	POP	ES

;-------------------------------------------
; command line parsing and disk activity removed from here
;-------------------------------------------

; load local file length
       mov ax, soundLen
       mov fileLen, ax           ; fetch from parameter stack
       mov ax, soundOfs
       add fileLen, ax           ; done checking is done by comparing
                                 ; current ofset with length, but
; that assumes that data begins at head of segment, which we can't assume.
; instead, we add the ofset in the segment of the real data to the "length"
; parameter so when the local ofset pointer equals the length, it will
; actually be pointing at the end of the data (which is what we want).
; to compensate for the data starting anywhere in the segment, we just
; initialize the local pointer to the proper value (see INIT REGISTERS)

	MOV	AX,3508H
	INT	21H
	MOV	WORD PTR OLDTMRINT,BX
	MOV	WORD PTR OLDTMRINT+2,ES

;mask timer interrupt

	IN	AL,21H
	OR	AL,01H
	OUT	21H,AL

;plug in the local timer interrupt routine

	MOV	DX,OFFSET TIMERINT
	MOV	AX,2508H
	INT	21H

; ** notes.  Jones is driving this process via the timer chip, the speed of
; which he is about to increase dramatically (see next code block).
;

;rev up timer

	MOV	AL,TCMODE
	OUT	TCADRC,AL
	MOV	AX,COUNTR
	OUT	TCADRD,AL
	MOV	AL,AH
	OUT	TCADRD,AL

;set DS

	ASSUME	DS:NOTHING
        mov     ax, soundSeg      ; fetch seg of sound data from parm stack
	MOV	DS,AX

;initialize registers

        MOV	BX,soundOfs    ; load ofsset of sound data

; right here, do ADD BX, startADDR or something equiv.
; see, the OFSET portion of the dynamically allocated SOUNDPTR record is
; where we would normally start, but if you want further into the segment
; than that, you must ADD to the pointer (BX).  Get it?

	MOV	BP,0
	MOV	CH,[BX]
	MOV	AH,0
	MOV	DX,PPIADR

;unmask timer interrupt          (and let the program fly!)

	IN	AL,21H
	AND	AL,0FEH
	OUT	21H,AL
	STI

;test for done

TFD:                            ; this loop just "waits" for the timer
	OR	BP,BP           ; to tell it that the sound is done.
	JE	TFD             ; really waiting for NOT (BP = 0)

;mask timer interrupt

	CLI
	IN	AL,21H
	OR	AL,01H
	OUT	21H,AL
	STI

;fix DS

	MOV	AX,CS
	MOV	DS,AX
	ASSUME	DS:CODE

;fix timer

	MOV	AL,TCMODE
	OUT	TCADRC,AL
	MOV	AL,0
	OUT	TCADRD,AL
	OUT	TCADRD,AL

;restore original timer interrupt vector

	PUSH	DS
	LDS	DX,CS:OLDTMRINT
	MOV	AX,2508H
	INT	21H
	POP	DS

;unmask timer interrupt

	IN	AL,21H
	AND	AL,0FEH
	OUT	21H,AL

;figure out how long the system 18.2 Hz
; timer has been off

	MOV	AX,COUNTR
	SHL	AX,1
	SHL	AX,1
	SHL	AX,1
        push ax                 ; old program used fileLen in cx
        mov     ax, soundLen    ; but we increased that variable
        mov     cx, ax          ; at the begining of the program.  insted,
        pop  ax                 ; we use soundLen which is what was meant.
	MUL	CX

;adjust the BIOS time of day to catch up

	PUSH	ES
	MOV	AX,40H
	MOV	ES,AX
	MOV	BX,6CH
	CLI
	ADD	ES:[BX],DX
	ADC	WORD PTR ES:[BX+2],0
	CMP	WORD PTR ES:[BX+2],18H
	JB	BIOSFIXED
	JA	WRAP
	CMP	WORD PTR ES:[BX],0B0H
	JB	BIOSFIXED
WRAP:	SUB	WORD PTR ES:[BX],0B0H
	SBB	WORD PTR ES:[BX+2],18H
BIOSFIXED: STI
	POP	ES
        pop     ds
       ret       ; parms are auto popped because of .MODEL directive
play endp

;timer interrupt routine

	ASSUME	DS:NOTHING,ES:NOTHING
	ASSUME	SS:NOTHING

OLDTMRINT DD	0

TIMERINT PROC	FAR

	OR	BP,BP
	JNZ	TMRINT1            ; go timrInt1 if BP is not zero (running)

	SUB	AL,AL              ; bp is zero here
	RCL	CH,1               ; ch holds current byte (rotates)
	RCL	AL,1
	RCL	AL,1
	OR	AL,NORMPPI         ; append bit to sound chip parameter
	OUT	DX,AL              ; send out latest bit in stream

	INC	AH                 ; counts bits
	CMP	AH,8
	JNE	TMRINT1
	SUB	AH,AH              ; reset bit counter

	INC	BX                 ; increment byte index
	MOV	CH,[BX]            ; load a new byte into the byte holder
	CMP	BX,cs:FILELEN      ; have we reached end of file?
	JNZ	TMRINT1            ;   no, we're done with this iteration
	INC	BP                 ;   yes, mark BP done (not (BP = 0))

TMRINT1:
	MOV	AL,20H
	OUT	20H,AL
	IRET

TIMERINT ENDP

FILELEN	DW ?            ; local copy of length
CODE	ENDS
        end start